#!/usr/bin/env python

# Import from PM Game
# Copyright 2007 by Brian C. Christensen

"""
First line: Format\tProject\t1

"""
# import wx

def Import(path):

    dp = Data.Project
    dt = Data.Task
    dr = Data.Resource

    projectid = 0
    taskids = {}
    
    infile = open(path, 'r')
    for line in infile:
        line = line.strip()
        fields = line.split('\t')
        print fields
        if fields[0] == 'Format':
            pass
        elif fields[0] == 'Project':
            change = {'Table': 'Project', 'PMGameXref': int(fields[1]),
                      'Name': fields[2]}
            projectid = Data.Update(change)['ID']
        elif fields[0] == 'Task':
            xref = int(fields[1])
            change = {'Table': 'Task', 'ProjectID': projectid,
                      'PMGameXref': xref, 'EffortHours': int(fields[3]),
                      'Name': fields[2]}
            taskid = Data.Update(change)['ID']
            taskids[xref] = taskid
            if len(fields) > 4:
                preids = fields[4].split(',')
                print preids
                for pre in preids:
                    print pre
                    if pre:
                        change = { 'Table': 'Dependency',
                            'PrerequisiteID': taskids[int(pre.strip())],
                            'TaskID': taskid }
                        update = Data.Update(change)

        elif fields[0] == 'Resource':
            change = {'Table': 'Resource', 'PMGameXref': int(fields[1]),
                      'Name': fields[2]}
            update = Data.Update(change)
        else:
            print fields
        
    Data.SetUndo("Import PM Game File")

def DoImport():

    wildcardx = "TXT (*.txt)|*.txt|" "All files (*.*)|*.*"
    dlg = wx.FileDialog(
        self, message="Open PM Game File ...", 
        defaultFile="", wildcard=wildcardx,
        style = wx.OPEN
        )

    dlg.SetFilterIndex(0)
    if dlg.ShowModal() == wx.ID_OK:
        path = dlg.GetPath()
        Import(path)

    dlg.Destroy()

DoImport()
